define([
    'underscore',
    'backbone',
    'App',
    'Global',
    'marionette',
    'text!modules/landing-page/landing-page.html',
    'modules/landing-page/device-dial-confirmation-popup-view',
    'modules/page/popup/external-nav-popup-view',
    'modules/learn-about-community-care/learn-about-community-care-popup-view',
], function(
    _,
    Backbone,
    app,
    Global,
    Marionette,
    template,
    DeviceDialConfirmationPopup,
    ExternalNavigationWarningPopup,
    LearnAboutCCPopup
) {
    'use strict';

    return Backbone.Marionette.View.extend({
        className: 'landing-page',
        template: _.template(template),
        events: {
            'click #login-btn': 'showLogin',
            'click .device-dial': 'openDeviceDial',
            'click .external-link': 'openExternalLink',
            'click #learn-cc': 'showLearnAboutCC',

        },
        onRender: function() {
            if (typeof gas !== 'undefined') {
                gas('send', 'pageview', 'landing-page');
            }
            this.$el.trigger('create');
        },
        showLogin: function () {
            Global.getUtilities().authorize();
        },
        showLearnAboutCC: function (e) {
            var learnAboutCCPopup = new LearnAboutCCPopup({elAfterClose: '#learn-cc'});
            learnAboutCCPopup.openPopup();
        },
        openDeviceDial: function (e) {
            var navigationWarning;

            e.preventDefault();
            navigationWarning = new DeviceDialConfirmationPopup({
                elAfterClose: e.currentTarget,
                model: new Backbone.Model({href: $(e.currentTarget).attr('href')}),
            });
            navigationWarning.openPopup();
        },
        openExternalLink: function (e) {
            var navigationWarning;
            e.preventDefault();
            navigationWarning = new ExternalNavigationWarningPopup({
                elAfterClose: e.currentTarget,
                model: new Backbone.Model({href: $(e.currentTarget).attr('href')}),
            });
            navigationWarning.openPopup();
        },
        templateContext: function () {
            return {
                ccIsDisabled: typeof app.disabledFeatures.get('CC_FEATURE_SET') !== 'undefined',
                vaFacilitiesLink: app.externalLinks.get('va-facilities'),
            };
        },
    });
});
